package gov.va.med.mhv.admin.service.calendar;

import java.util.List;

import gov.va.med.mhv.admin.dto.CalendarCategoryDTO;
import gov.va.med.mhv.admin.dto.CalendarEventDTO;
import gov.va.med.mhv.admin.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.admin.dto.CategoryDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

public interface CalendarEventService {

	public List<CalendarEventDTO> getAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> getNationalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> getRegionalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> getGenericEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public void saveCalendarEvent(CalendarEventDTO calendarEventDto) throws MHVException;

	public void deleteCalendarEvent(Long calendarEventId) throws MHVException;

	public List<CalendarEventDTO> getPersonalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> getAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> getAllVHAReminderEventsByVisn(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> findAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CalendarEventDTO> findAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;

	public List<CategoryDTO> getAllCategories() throws MHVException;

	public List<CategoryDTO> getCheckedCategories(Long userProfileId) throws MHVException;

	public List<CalendarCategoryDTO> getActiveCategories(Long userProfileId) throws MHVException;

	public void saveUserCalCatList(List<CategoryDTO> userCalCatList, Long userProfileId) throws MHVException;

	public void deleteUserCalCat(Long userCalCatId) throws MHVException;

	public void deleteCategoriesForView(Long userProfileId) throws MHVException;

	public CalendarEventDTO getPersonalEventById(Long eventId) throws MHVException;
	
	
	public List<CalendarEventDTO> getEventsForAdminUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)
			throws MHVException;


}
